/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.helper.PenAttributes;
import net.nooj4nlp.gui.components.JSTree;

public class STree {
    public static int LINE;
    public static int currentleftposition;
    public String label;
    private ArrayList<Object> children;
    private int depth;
    private int width;
    private int position;
    private int x;
    private int y;
    private JSTree panel;
    private Font font;
    private Font boldFont;
    private Font largeFont;
    private HashMap<String, PenAttributes<Color, Float>> pen;
    private Color bColor;
    private Color fColor;
    private Color rColor;

    public STree(String label, JSTree panel1) {
        this.label = label;
        this.children = null;
        this.y = -1;
        this.x = -1;
        this.bColor = Color.BLACK;
        this.fColor = Color.BLUE;
        this.rColor = Color.RED;
        this.pen = new HashMap();
        this.pen.put("pen", new PenAttributes(this.bColor, 1.0f));
        this.pen.put("fpen", new PenAttributes(this.fColor, 1.0f));
        this.panel = panel1;
        this.font = this.panel.getFont().deriveFont(0);
        this.boldFont = this.panel.getFont().deriveFont(1);
        this.largeFont = this.panel.getFont().deriveFont(1, this.font.getSize() * 3);
    }

    public void addChild(STree c) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(c);
    }

    public int computeDepth() {
        if (this.children == null) {
            this.depth = 1;
        } else {
            int max = 0;
            for (Object c : this.children) {
                int under;
                if (c == null || (under = ((STree)c).computeDepth()) <= max) continue;
                max = under;
            }
            this.depth = max + 1;
        }
        return this.depth;
    }

    public void computeYPosition(int panelheight, int height) {
        this.y = panelheight - this.depth * height;
        if (this.children != null) {
            for (Object c : this.children) {
                if (c == null) continue;
                ((STree)c).computeYPosition(panelheight, height);
            }
        }
    }

    public void computeWidth(Graphics g, Font f, boolean dispLexeme) {
        FontMetrics metrics = g.getFontMetrics(f);
        if (this.children == null) {
            if (this.label.charAt(0) == '$') {
                this.width = metrics.stringWidth(this.label);
                return;
            }
            String entry = null;
            String lemma = null;
            String category = null;
            String[] features = null;
            RefObject<Object> entryRef = new RefObject<Object>(entry);
            RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
            RefObject<Object> categoryRef = new RefObject<Object>(category);
            RefObject<Object> featuresRef = new RefObject<Object>(features);
            Dic.parseLexemeSymbol(this.label, entryRef, lemmaRef, categoryRef, featuresRef, null);
            entry = (String)entryRef.argvalue;
            lemma = (String)lemmaRef.argvalue;
            category = (String)categoryRef.argvalue;
            features = (String[])featuresRef.argvalue;
            if (dispLexeme) {
                int w3;
                int w2;
                this.width = entry != null ? metrics.stringWidth(entry) : 0;
                int n = w2 = lemma != null ? metrics.stringWidth(lemma) : 0;
                if (w2 > this.width) {
                    this.width = w2;
                }
                int n2 = w3 = category + Dic.getRidOfSpecialFeaturesPlus(features) != null ? metrics.stringWidth(category + Dic.getRidOfSpecialFeaturesPlus(features)) : 0;
                if (w3 > this.width) {
                    this.width = w3;
                }
            } else {
                this.width = entry != null && entry.equals("") ? metrics.stringWidth(lemma) : (entry != null ? metrics.stringWidth(entry) : 0);
            }
        } else {
            this.width = this.label != null ? metrics.stringWidth(this.label) : 0;
            for (Object c : this.children) {
                if (c == null) continue;
                ((STree)c).computeWidth(g, f, dispLexeme);
            }
        }
    }

    public void computeXPosition(int margin) {
        if (this.children == null) {
            this.x = currentleftposition;
            currentleftposition += this.width + margin;
            this.position = this.x + this.width / 2;
        } else {
            int pos = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                STree c = (STree)this.children.get(i);
                if (c == null) continue;
                c.computeXPosition(margin);
                pos += c.position;
            }
            this.position = pos / this.children.size();
            this.x = this.position - this.width / 2;
        }
    }

    public void draw(Graphics g, boolean dispLexeme, HashMap<String, ArrayList<Integer>> bridges) {
        if (this.x == -1 || this.y == -1) {
            return;
        }
        if (this.children == null) {
            if (this.label.charAt(0) == '$') {
                this.drawLeafVariable(g, this.rColor, this.label.substring(1));
                return;
            }
            String entry = null;
            String lemma = null;
            String category = null;
            String[] features = null;
            RefObject<Object> entryRef = new RefObject<Object>(entry);
            RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
            RefObject<Object> categoryRef = new RefObject<Object>(category);
            RefObject<Object> featuresRef = new RefObject<Object>(features);
            Dic.parseLexemeSymbol(this.label, entryRef, lemmaRef, categoryRef, featuresRef, null);
            entry = (String)entryRef.argvalue;
            lemma = (String)lemmaRef.argvalue;
            category = (String)categoryRef.argvalue;
            features = (String[])featuresRef.argvalue;
            String information = Dic.getRidOfSpecialFeaturesPlus(features);
            this.drawLeaf(g, dispLexeme, this.bColor, this.pen.get("pen"), entry, lemma, category, information);
        } else {
            Graphics2D graphics = (Graphics2D)g;
            graphics.setColor(this.bColor);
            graphics.setFont(this.boldFont);
            graphics.drawString(this.label, this.x, this.y + LINE / 2);
            for (Object o : this.children) {
                STree c = (STree)o;
                if (c == null) continue;
                c.draw(g, dispLexeme, bridges);
                if (c.children == null && c.label.charAt(0) == '$') continue;
                graphics.setColor((Color)this.pen.get((Object)"pen").color);
                graphics.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
                graphics.drawLine(this.position, this.y + LINE, c.position, this.y + LINE * 4);
                graphics.drawLine(c.position, this.y + LINE * 4, c.position, c.y - LINE / 2);
            }
        }
    }

    private void drawLeaf(Graphics g, boolean dispLexeme, Color brush, PenAttributes<Color, Float> penAttributes, String entry, String lemma, String category, String information) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(brush);
        graphics.setFont(this.font);
        if (dispLexeme) {
            if (information != null && information.equals("WF")) {
                if (entry != null && !entry.equals(lemma)) {
                    graphics.drawString(entry, this.x, this.y + LINE / 3 + LINE / 2);
                    graphics.drawString(lemma, this.x, this.y + 2 * LINE - LINE / 3 + LINE / 2);
                } else {
                    graphics.drawString(entry, this.x, this.y + LINE + LINE / 2);
                }
            } else if (!(entry == null || entry.equals(lemma) || entry.equals("") || lemma.equals("SYNTAX"))) {
                graphics.drawString(entry, this.x, this.y + LINE / 2);
                graphics.drawString(lemma, this.x, this.y + LINE + LINE / 2);
                graphics.drawString(category + information, this.x, this.y + 2 * LINE + LINE / 2);
            } else {
                if (entry != null && !entry.equals("")) {
                    graphics.drawString(entry, this.x, this.y + LINE / 3 + LINE / 2);
                } else if (lemma != null && !lemma.equals("SYNTAX")) {
                    graphics.drawString(lemma, this.x, this.y + LINE / 3 + LINE / 2);
                }
                graphics.drawString(category + information, this.x, this.y + 2 * LINE - LINE / 3 + LINE / 2);
            }
            graphics.setColor((Color)this.pen.get((Object)"pen").color);
            graphics.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            graphics.drawLine(this.x, this.y - LINE / 2, this.x + this.width, this.y - LINE / 2);
            graphics.drawLine(this.x, this.y + 3 * LINE, this.x + this.width, this.y + 3 * LINE);
            graphics.drawLine(this.x, this.y + 3 * LINE, this.x, this.y - LINE / 2);
            graphics.drawLine(this.x + this.width, this.y + 3 * LINE, this.x + this.width, this.y - LINE / 2);
        } else {
            if (entry != null && entry.equals("")) {
                graphics.drawString(lemma, this.x, this.y + LINE / 2);
            } else {
                graphics.drawString(entry, this.x, this.y + LINE / 2);
            }
            graphics.setColor((Color)this.pen.get((Object)"pen").color);
            graphics.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            graphics.drawLine(this.x, this.y - LINE / 2, this.x + this.width, this.y - LINE / 2);
            graphics.drawLine(this.x, this.y + LINE, this.x + this.width, this.y + LINE);
            graphics.drawLine(this.x, this.y + LINE, this.x, this.y - LINE / 2);
            graphics.drawLine(this.x + this.width, this.y + LINE, this.x + this.width, this.y - LINE / 2);
        }
    }

    private void drawLeafVariable(Graphics g, Color brush, String substring) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(brush);
        graphics.setFont(this.largeFont);
        graphics.drawString(Character.toString(this.label.charAt(0)), this.x, this.y + LINE / 2);
        if (this.label.length() > 1) {
            FontMetrics metrics = g.getFontMetrics(this.largeFont);
            int w = metrics.stringWidth("(");
            int h = metrics.getHeight();
            graphics.setFont(this.font);
            graphics.drawString(this.label.substring(1), this.x + w / 2, this.y + h + LINE / 2);
        }
    }
}

